/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import com.beust.jcommander.JCommander;
import java.net.BindException;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.management.ObjectName;
import javax.servlet.Servlet;
import org.openqa.grid.internal.cli.StandaloneCliOptions;
import org.openqa.grid.internal.utils.configuration.GridNodeConfiguration;
import org.openqa.grid.internal.utils.configuration.StandaloneConfiguration;
import org.openqa.grid.selenium.node.ChromeMutator;
import org.openqa.grid.selenium.node.FirefoxMutator;
import org.openqa.grid.shared.GridNodeServer;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.remote.server.ActiveSessions;
import org.openqa.selenium.remote.server.DefaultPipeline;
import org.openqa.selenium.remote.server.NewSessionPipeline;
import org.openqa.selenium.remote.server.WebDriverServlet;
import org.openqa.selenium.remote.server.jmx.JMXHelper;
import org.openqa.selenium.remote.server.jmx.ManagedService;
import org.seleniumhq.jetty9.security.ConstraintMapping;
import org.seleniumhq.jetty9.security.ConstraintSecurityHandler;
import org.seleniumhq.jetty9.server.Connector;
import org.seleniumhq.jetty9.server.Handler;
import org.seleniumhq.jetty9.server.HttpConfiguration;
import org.seleniumhq.jetty9.server.HttpConnectionFactory;
import org.seleniumhq.jetty9.server.Server;
import org.seleniumhq.jetty9.server.ServerConnector;
import org.seleniumhq.jetty9.server.handler.ContextHandler;
import org.seleniumhq.jetty9.servlet.ServletContextHandler;
import org.seleniumhq.jetty9.util.security.Constraint;
import org.seleniumhq.jetty9.util.thread.QueuedThreadPool;

@ManagedService(objectName="org.seleniumhq.server:type=SeleniumServer")
public class SeleniumServer
implements GridNodeServer {
    private static final Logger LOG = Logger.getLogger(SeleniumServer.class.getName());
    private Server server;
    private StandaloneConfiguration configuration;
    private Map<String, Class<? extends Servlet>> extraServlets;
    private final Object shutdownLock = new Object();
    private static final int MAX_SHUTDOWN_RETRIES = 8;
    private ObjectName objectName;

    public SeleniumServer(StandaloneConfiguration configuration) {
        this.configuration = configuration;
        this.objectName = new JMXHelper().register(this).getObjectName();
    }

    @Override
    public int getRealPort() {
        if (this.server.isStarted()) {
            ServerConnector socket = (ServerConnector)this.server.getConnectors()[0];
            return socket.getPort();
        }
        return this.configuration.port;
    }

    private void addRcSupport(ServletContextHandler handler) {
        try {
            Class<Servlet> rcServlet = Class.forName("com.thoughtworks.selenium.webdriven.WebDriverBackedSeleniumServlet", false, this.getClass().getClassLoader()).asSubclass(Servlet.class);
            handler.addServlet(rcServlet, "/selenium-server/driver/");
            LOG.info("Bound legacy RC support");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private void addExtraServlets(ServletContextHandler handler) {
        if (this.extraServlets != null && this.extraServlets.size() > 0) {
            for (String path : this.extraServlets.keySet()) {
                handler.addServlet(this.extraServlets.get(path), path);
            }
        }
    }

    @Override
    public void setConfiguration(StandaloneConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void setExtraServlets(Map<String, Class<? extends Servlet>> extraServlets) {
        this.extraServlets = extraServlets;
    }

    @Override
    public boolean boot() {
        long inactiveSessionTimeoutSeconds;
        this.server = this.configuration.jettyMaxThreads != null && this.configuration.jettyMaxThreads > 0 ? new Server(new QueuedThreadPool(this.configuration.jettyMaxThreads)) : new Server();
        ServletContextHandler handler = new ServletContextHandler(2);
        if (this.configuration.browserTimeout != null && this.configuration.browserTimeout >= 0) {
            handler.setInitParameter("webdriver.server.browser.timeout", String.valueOf(this.configuration.browserTimeout));
        }
        long l = inactiveSessionTimeoutSeconds = this.configuration.timeout == null ? 9223372036854775L : (long)this.configuration.timeout.intValue();
        if (this.configuration.timeout != null && this.configuration.timeout >= 0) {
            handler.setInitParameter("webdriver.server.session.timeout", String.valueOf(inactiveSessionTimeoutSeconds));
        }
        NewSessionPipeline pipeline = this.createPipeline(this.configuration);
        handler.setAttribute(WebDriverServlet.NEW_SESSION_PIPELINE_KEY, pipeline);
        handler.setContextPath("/");
        handler.addServlet(WebDriverServlet.class, "/wd/hub/*");
        handler.addServlet(WebDriverServlet.class, "/webdriver/*");
        handler.setInitParameter("webdriver.server.consoleservlet.path", "/wd/hub");
        handler.setInitParameter("webdriver.server.displayhelpservlet.type", this.configuration.role);
        this.addRcSupport(handler);
        this.addExtraServlets(handler);
        ConstraintSecurityHandler securityHandler = (ConstraintSecurityHandler)handler.getSecurityHandler();
        Constraint disableTrace = new Constraint();
        disableTrace.setName("Disable TRACE");
        disableTrace.setAuthenticate(true);
        ConstraintMapping disableTraceMapping = new ConstraintMapping();
        disableTraceMapping.setConstraint(disableTrace);
        disableTraceMapping.setMethod("TRACE");
        disableTraceMapping.setPathSpec("/");
        securityHandler.addConstraintMapping(disableTraceMapping);
        Constraint enableOther = new Constraint();
        enableOther.setName("Enable everything but TRACE");
        ConstraintMapping enableOtherMapping = new ConstraintMapping();
        enableOtherMapping.setConstraint(enableOther);
        enableOtherMapping.setMethodOmissions(new String[]{"TRACE"});
        enableOtherMapping.setPathSpec("/");
        securityHandler.addConstraintMapping(enableOtherMapping);
        this.server.setHandler(handler);
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSecureScheme("https");
        ServerConnector http = new ServerConnector(this.server, new HttpConnectionFactory(httpConfig));
        if (this.configuration.port == null) {
            this.configuration.port = 4444;
        }
        if (this.configuration.host != null) {
            http.setHost(this.configuration.host);
        }
        http.setPort(this.configuration.port);
        http.setIdleTimeout(500000L);
        this.server.setConnectors(new Connector[]{http});
        try {
            this.server.start();
        }
        catch (Exception e) {
            try {
                this.server.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (e instanceof BindException) {
                LOG.severe(String.format("Port %s is busy, please choose a free port and specify it using -port option", this.configuration.port));
                return false;
            }
            throw new RuntimeException(e);
        }
        LOG.info(String.format("Selenium Server is up and running on port %s", this.configuration.port));
        return true;
    }

    private NewSessionPipeline createPipeline(StandaloneConfiguration configuration) {
        NewSessionPipeline.Builder builder = DefaultPipeline.createDefaultPipeline();
        if (configuration instanceof GridNodeConfiguration) {
            ((GridNodeConfiguration)configuration).capabilities.forEach(caps -> {
                builder.addCapabilitiesMutator(new ChromeMutator((Capabilities)caps));
                builder.addCapabilitiesMutator(new FirefoxMutator((Capabilities)caps));
                builder.addCapabilitiesMutator(c -> new ImmutableCapabilities(c.asMap().entrySet().stream().filter(e -> !((String)e.getKey()).startsWith("server:")).filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))));
            });
        }
        return builder.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        int numTries;
        Exception shutDownException = null;
        for (numTries = 0; numTries <= 8; ++numTries) {
            try {
                Object object = this.shutdownLock;
                synchronized (object) {
                    this.server.stop();
                    break;
                }
            }
            catch (Exception ex) {
                shutDownException = ex;
                continue;
            }
        }
        this.stopAllBrowsers();
        if (numTries > 8 && null != shutDownException) {
            throw new RuntimeException(shutDownException);
        }
        new JMXHelper().unregister(this.objectName);
    }

    private void stopAllBrowsers() {
        for (Handler handler : this.server.getHandlers()) {
            Object value;
            ContextHandler.Context context;
            if (!(handler instanceof ServletContextHandler) || (context = ((ServletContextHandler)handler).getServletContext()) == null || !((value = context.getAttribute(WebDriverServlet.ACTIVE_SESSIONS_KEY)) instanceof ActiveSessions)) continue;
            ((ActiveSessions)value).getAllSessions().parallelStream().forEach(session -> {
                try {
                    session.stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
    }

    public static void main(String[] argv) {
        StandaloneCliOptions options = new StandaloneCliOptions().parse(argv);
        if (options.help.booleanValue()) {
            StringBuilder message = new StringBuilder();
            new JCommander(options).usage(message);
            System.err.println(message.toString());
            return;
        }
        SeleniumServer server = new SeleniumServer(options.toConfiguration());
        server.boot();
    }

    public static void usage(String msg) {
        if (msg != null) {
            System.out.println(msg);
        }
        JCommander jCommander = new JCommander(new StandaloneCliOptions());
        jCommander.usage();
    }
}

