/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import com.google.common.base.Preconditions;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.io.TemporaryFilesystem;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.server.ActiveSession;
import org.openqa.selenium.remote.server.DriverProvider;
import org.openqa.selenium.remote.server.DriverSessions;
import org.openqa.selenium.remote.server.JsonHttpCommandHandler;
import org.openqa.selenium.remote.server.KnownElements;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.remote.server.SessionFactory;

class InMemorySession
implements ActiveSession {
    private static final Logger LOG = Logger.getLogger(InMemorySession.class.getName());
    private final WebDriver driver;
    private final Map<String, Object> capabilities;
    private final SessionId id;
    private final Dialect downstream;
    private final TemporaryFilesystem filesystem;
    private final JsonHttpCommandHandler handler;

    private InMemorySession(WebDriver driver, Capabilities capabilities, Dialect downstream) {
        this.driver = Preconditions.checkNotNull(driver);
        Capabilities caps = driver instanceof HasCapabilities ? ((HasCapabilities)((Object)driver)).getCapabilities() : capabilities;
        this.capabilities = caps.asMap().entrySet().stream().filter(e -> e.getValue() != null).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        this.id = new SessionId(UUID.randomUUID().toString());
        this.downstream = Preconditions.checkNotNull(downstream);
        File tempRoot = new File(StandardSystemProperty.JAVA_IO_TMPDIR.value(), this.id.toString());
        Preconditions.checkState(tempRoot.mkdirs());
        this.filesystem = TemporaryFilesystem.getTmpFsBasedOn(tempRoot);
        this.handler = new JsonHttpCommandHandler(new PretendDriverSessions(), LOG);
    }

    @Override
    public void execute(HttpRequest req, HttpResponse resp) throws IOException {
        this.handler.handleRequest(req, resp);
    }

    @Override
    public SessionId getId() {
        return this.id;
    }

    @Override
    public Dialect getUpstreamDialect() {
        return Dialect.OSS;
    }

    @Override
    public Dialect getDownstreamDialect() {
        return this.downstream;
    }

    @Override
    public Map<String, Object> getCapabilities() {
        return this.capabilities;
    }

    @Override
    public TemporaryFilesystem getFileSystem() {
        return this.filesystem;
    }

    @Override
    public WebDriver getWrappedDriver() {
        return this.driver;
    }

    @Override
    public void stop() {
        this.driver.quit();
    }

    private class ActualSession
    implements Session {
        private final KnownElements knownElements = new KnownElements();
        private volatile String screenshot;

        private ActualSession() {
        }

        @Override
        public void close() {
            InMemorySession.this.driver.quit();
        }

        @Override
        public WebDriver getDriver() {
            return InMemorySession.this.driver;
        }

        @Override
        public KnownElements getKnownElements() {
            return this.knownElements;
        }

        @Override
        public Map<String, Object> getCapabilities() {
            return InMemorySession.this.capabilities;
        }

        @Override
        public void attachScreenshot(String base64EncodedImage) {
            this.screenshot = base64EncodedImage;
        }

        @Override
        public String getAndClearScreenshot() {
            String toReturn = this.screenshot;
            this.screenshot = null;
            return toReturn;
        }

        @Override
        public SessionId getSessionId() {
            return InMemorySession.this.getId();
        }

        @Override
        public TemporaryFilesystem getTemporaryFileSystem() {
            return InMemorySession.this.getFileSystem();
        }
    }

    private class PretendDriverSessions
    implements DriverSessions {
        private final Session session;

        private PretendDriverSessions() {
            this.session = new ActualSession();
        }

        @Override
        public Session get(SessionId sessionId) {
            return InMemorySession.this.getId().equals(sessionId) ? this.session : null;
        }

        @Override
        public Set<SessionId> getSessions() {
            return ImmutableSet.of(InMemorySession.this.getId());
        }
    }

    public static class Factory
    implements SessionFactory {
        private final DriverProvider provider;

        public Factory(DriverProvider provider) {
            this.provider = provider;
        }

        @Override
        public boolean isSupporting(Capabilities capabilities) {
            return this.provider.canCreateDriverInstanceFor(capabilities);
        }

        @Override
        public Optional<ActiveSession> apply(Set<Dialect> downstreamDialects, Capabilities caps) {
            try {
                if (!this.provider.canCreateDriverInstanceFor(caps)) {
                    return Optional.empty();
                }
                WebDriver driver = this.provider.newInstance(caps);
                Dialect downstream = downstreamDialects.contains((Object)Dialect.OSS) || downstreamDialects.isEmpty() ? Dialect.OSS : downstreamDialects.iterator().next();
                return Optional.of(new InMemorySession(driver, caps, downstream));
            }
            catch (IllegalStateException e) {
                return Optional.empty();
            }
        }

        public String toString() {
            return this.getClass() + " (provider: " + this.provider + ")";
        }
    }
}

