/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.os;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.openqa.selenium.Platform;
import org.openqa.selenium.os.CommandLine;

public class WindowsUtils {
    private static Logger LOG = Logger.getLogger(WindowsUtils.class.getName());
    private static final boolean THIS_IS_WINDOWS = Platform.getCurrent().is(Platform.WINDOWS);
    private static String taskkill = null;
    private static Properties env = null;

    @Deprecated
    public static void killByName(String name) {
        WindowsUtils.executeCommand(WindowsUtils.findTaskKill(), "/f", "/t", "/im", name);
    }

    @Deprecated
    public static void killPID(String processID) {
        WindowsUtils.executeCommand(WindowsUtils.findTaskKill(), "/f", "/t", "/pid", processID);
    }

    private static String executeCommand(String commandName, String ... args) {
        CommandLine cmd = new CommandLine(commandName, args);
        cmd.execute();
        String output = cmd.getStdOut();
        if (cmd.getExitCode() == 0 || cmd.getExitCode() == 128 || cmd.getExitCode() == 255) {
            return output;
        }
        throw new RuntimeException("exec return code " + cmd.getExitCode() + ": " + output);
    }

    public static synchronized Properties loadEnvironment() {
        if (env != null) {
            return env;
        }
        env = new Properties();
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            env.put(entry.getKey(), entry.getValue());
        }
        return env;
    }

    public static String getProgramFilesPath() {
        return WindowsUtils.getEnvVarPath("ProgramFiles", "C:\\Program Files").replace(" (x86)", "");
    }

    public static String getProgramFiles86Path() {
        return WindowsUtils.getEnvVarPath("ProgramFiles(x86)", "C:\\Program Files (x86)");
    }

    private static String getEnvVarPath(String envVar, String defaultValue) {
        File programFiles;
        String pf = WindowsUtils.getEnvVarIgnoreCase(envVar);
        if (pf != null && (programFiles = new File(pf)).exists()) {
            return programFiles.getAbsolutePath();
        }
        return new File(defaultValue).getAbsolutePath();
    }

    public static ImmutableList<String> getPathsInProgramFiles(String childPath) {
        return ((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().add(WindowsUtils.getFullPath(WindowsUtils.getProgramFilesPath(), childPath))).add(WindowsUtils.getFullPath(WindowsUtils.getProgramFiles86Path(), childPath))).build();
    }

    private static String getFullPath(String parent, String child) {
        return new File(parent, child).getAbsolutePath();
    }

    public static String getEnvVarIgnoreCase(String var) {
        Properties p = WindowsUtils.loadEnvironment();
        for (String key : p.stringPropertyNames()) {
            if (!key.equalsIgnoreCase(var)) continue;
            return env.getProperty(key);
        }
        return null;
    }

    @Deprecated
    public static File findSystemRoot() {
        Properties p = WindowsUtils.loadEnvironment();
        String systemRootPath = p.getProperty("SystemRoot");
        if (systemRootPath == null) {
            systemRootPath = p.getProperty("SYSTEMROOT");
        }
        if (systemRootPath == null) {
            systemRootPath = p.getProperty("systemroot");
        }
        if (systemRootPath == null) {
            throw new RuntimeException("SystemRoot apparently not set!");
        }
        File systemRoot = new File(systemRootPath);
        if (!systemRoot.exists()) {
            throw new RuntimeException("SystemRoot doesn't exist: " + systemRootPath);
        }
        return systemRoot;
    }

    @Deprecated
    public static String findTaskKill() {
        if (taskkill != null) {
            return taskkill;
        }
        File systemRoot = WindowsUtils.findSystemRoot();
        File taskkillExe = new File(systemRoot, "system32/taskkill.exe");
        if (taskkillExe.exists()) {
            taskkill = taskkillExe.getAbsolutePath();
            return taskkill;
        }
        LOG.warning("Couldn't find taskkill! Hope it's on the path...");
        taskkill = "taskkill";
        return taskkill;
    }

    public static boolean thisIsWindows() {
        return THIS_IS_WINDOWS;
    }
}

