/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.web.servlet;

import com.google.common.base.Throwables;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openqa.grid.internal.ExternalSessionKey;
import org.openqa.grid.internal.GridRegistry;
import org.openqa.grid.web.servlet.RegistryBasedServlet;
import org.openqa.grid.web.servlet.handler.RequestHandler;
import org.openqa.grid.web.servlet.handler.SeleniumBasedRequest;
import org.openqa.grid.web.servlet.handler.WebDriverRequest;
import org.openqa.selenium.json.Json;

public class DriverServlet
extends RegistryBasedServlet {
    private static final long serialVersionUID = -1693540182205547227L;

    public DriverServlet() {
        this(null);
    }

    public DriverServlet(GridRegistry registry) {
        super(registry);
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.process(request, response);
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.process(request, response);
    }

    @Override
    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.process(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(HttpServletRequest request, HttpServletResponse response) throws IOException {
        RequestHandler req = null;
        SeleniumBasedRequest r = null;
        try {
            r = SeleniumBasedRequest.createFromRequest(request, this.getRegistry());
            req = new RequestHandler(r, response, this.getRegistry());
            req.process();
        }
        catch (Throwable e) {
            if (r instanceof WebDriverRequest && !response.isCommitted()) {
                response.reset();
                response.setContentType("application/json");
                response.setCharacterEncoding("UTF-8");
                response.setStatus(500);
                TreeMap<String, Object> resp = new TreeMap<String, Object>();
                ExternalSessionKey serverSession = req.getServerSession();
                resp.put("sessionId", serverSession != null ? serverSession.getKey() : null);
                resp.put("status", 13);
                TreeMap<String, Object> value = new TreeMap<String, Object>();
                value.put("message", e.getMessage());
                value.put("class", e.getClass().getCanonicalName());
                LinkedList stacktrace = new LinkedList();
                for (StackTraceElement ste : e.getStackTrace()) {
                    TreeMap<String, Object> st = new TreeMap<String, Object>();
                    st.put("fileName", ste.getFileName());
                    st.put("className", ste.getClassName());
                    st.put("methodName", ste.getMethodName());
                    st.put("lineNumber", ste.getLineNumber());
                    stacktrace.add(st);
                }
                value.put("stackTrace", stacktrace);
                value.put("error", "unknown error");
                value.put("message", e.getMessage());
                value.put("stacktrace", Throwables.getStackTraceAsString(e));
                resp.put("value", value);
                String json = new Json().toJson(resp);
                byte[] bytes = json.getBytes("UTF-8");
                try (ByteArrayInputStream in = new ByteArrayInputStream(bytes);){
                    response.setHeader("Content-Length", Integer.toString(bytes.length));
                    ByteStreams.copy(in, response.getOutputStream());
                }
                finally {
                    response.flushBuffer();
                }
            }
            throw new IOException(e);
        }
    }
}

