/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal.cli;

import com.beust.jcommander.Parameter;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openqa.grid.common.exception.GridConfigurationException;
import org.openqa.grid.internal.cli.CommonCliOptions;
import org.openqa.grid.internal.cli.CustomConverter;
import org.openqa.grid.internal.utils.configuration.GridConfiguration;

abstract class CommonGridCliOptions
extends CommonCliOptions {
    @Parameter(names={"-cleanUpCycle"}, description="<Integer> in ms : specifies how often the hub will poll running proxies for timed-out (i.e. hung) threads. Must also specify \"timeout\" option")
    private Integer cleanUpCycle;
    @Parameter(names={"-custom"}, description="<String> : comma separated key=value pairs for custom grid extensions. NOT RECOMMENDED -- may be deprecated in a future revision. Example: -custom myParamA=Value1,myParamB=Value2", converter=CustomConverter.class)
    private Map<String, String> custom;
    @Parameter(names={"-maxSession"}, description="<Integer> max number of tests that can run at the same time on the node, irrespective of the browser used")
    private Integer maxSession;
    @Parameter(names={"-servlet", "-servlets"}, description="<String> : list of extra servlets the grid (hub or node) will make available. Specify multiple on the command line: -servlet tld.company.ServletA -servlet tld.company.ServletB. The servlet must exist in the path: /grid/admin/ServletA /grid/admin/ServletB")
    private List<String> servlets;
    @Parameter(names={"-withoutServlet", "-withoutServlets"}, description="<String> : list of default (hub or node) servlets to disable. Advanced use cases only. Not all default servlets can be disabled. Specify multiple on the command line: -withoutServlet tld.company.ServletA -withoutServlet tld.company.ServletB")
    private List<String> withoutServlets;

    CommonGridCliOptions() {
    }

    void fillCommonGridConfiguration(GridConfiguration configuration) {
        if (this.cleanUpCycle != null) {
            configuration.cleanUpCycle = this.cleanUpCycle;
        }
        if (this.custom != null) {
            configuration.custom = this.custom;
        }
        if (this.maxSession != null) {
            configuration.maxSession = this.maxSession;
        }
        if (this.servlets != null) {
            configuration.servlets = this.servlets;
        }
        if (this.withoutServlets != null) {
            configuration.withoutServlets = this.withoutServlets;
        }
    }

    /*
     * Exception decompiling
     */
    String builtIn(String resource) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String fromConfigFile(String file) {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
            String string = br.lines().collect(Collectors.joining("\n"));
            return string;
        }
        catch (IOException e) {
            throw new GridConfigurationException("Cannot read file " + file + ", " + e.getMessage(), e);
        }
    }
}

