/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxStaticFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.URLSearchParams;
import com.gargoylesoftware.htmlunit.javascript.host.file.File;
import com.gargoylesoftware.htmlunit.util.UrlUtils;
import java.net.MalformedURLException;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import org.apache.commons.lang3.StringUtils;

@JsxClass
public class URL
extends SimpleScriptable {
    private java.net.URL url_;

    public URL() {
    }

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.EDGE})
    public URL(String url, Object base) {
        String baseStr = null;
        if (Undefined.instance != base) {
            baseStr = Context.toString(base);
        }
        try {
            if (StringUtils.isBlank(baseStr)) {
                this.url_ = UrlUtils.toUrlUnsafe(url);
            } else {
                java.net.URL baseUrl = UrlUtils.toUrlUnsafe(baseStr);
                this.url_ = new java.net.URL(baseUrl, url);
            }
        }
        catch (MalformedURLException e) {
            throw ScriptRuntime.typeError(e.toString());
        }
    }

    @JsxStaticFunction
    public static String createObjectURL(Object fileOrBlob) {
        if (fileOrBlob instanceof File) {
            File file = (File)fileOrBlob;
            return file.getFile().toURI().normalize().toString();
        }
        return null;
    }

    @JsxStaticFunction
    public static void revokeObjectURL(Object objectURL) {
    }

    @JsxGetter
    public Object getOrigin() {
        if (this.url_ == null) {
            return null;
        }
        return this.url_.getProtocol() + "://" + this.url_.getHost();
    }

    @JsxGetter
    public URLSearchParams getSearchParams() {
        if (this.url_ == null) {
            return null;
        }
        return new URLSearchParams(this.url_.getQuery());
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        if (this.url_ == null) {
            return super.getDefaultValue(hint);
        }
        if (StringUtils.isEmpty(this.url_.getPath())) {
            return this.url_.toExternalForm() + "/";
        }
        return this.url_.toExternalForm();
    }
}

