/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.DisabledElement;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeEvent;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeListener;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlPasswordInput;
import com.gargoylesoftware.htmlunit.html.HtmlSubmitInput;
import com.gargoylesoftware.htmlunit.html.HtmlTextArea;
import com.gargoylesoftware.htmlunit.html.HtmlTextInput;
import com.gargoylesoftware.htmlunit.html.Keyboard;
import com.gargoylesoftware.htmlunit.html.SubmittableElement;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Document;
import com.gargoylesoftware.htmlunit.javascript.host.dom.MutationObserver;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import com.gargoylesoftware.htmlunit.javascript.host.event.EventTarget;
import com.gargoylesoftware.htmlunit.javascript.host.event.KeyboardEvent;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLDocument;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public abstract class HtmlElement
extends DomElement {
    public static final Short TAB_INDEX_OUT_OF_BOUNDS = new Short(Short.MIN_VALUE);
    private Collection<HtmlAttributeChangeListener> attributeListeners_ = new LinkedHashSet<HtmlAttributeChangeListener>();
    private HtmlForm owningForm_;
    private boolean shiftPressed_;
    private boolean ctrlPressed_;
    private boolean altPressed_;

    protected HtmlElement(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        this("http://www.w3.org/1999/xhtml", qualifiedName, page, attributes);
    }

    protected HtmlElement(String namespaceURI, String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(namespaceURI, qualifiedName, page, attributes);
    }

    @Override
    protected void setAttributeNS(String namespaceURI, String qualifiedName, String attributeValue, boolean notifyAttributeChangeListeners, boolean notifyMutationObservers) {
        boolean mappedElement;
        if (null == this.getHtmlPageOrNull()) {
            super.setAttributeNS(namespaceURI, qualifiedName, attributeValue, notifyAttributeChangeListeners, notifyMutationObservers);
            return;
        }
        String oldAttributeValue = this.getAttribute(qualifiedName);
        HtmlPage htmlPage = (HtmlPage)this.getPage();
        boolean bl = mappedElement = this.isAttachedToPage() && HtmlPage.isMappedElement(htmlPage, qualifiedName);
        if (mappedElement) {
            htmlPage.removeMappedElement(this);
        }
        HtmlAttributeChangeEvent event = oldAttributeValue == ATTRIBUTE_NOT_DEFINED ? new HtmlAttributeChangeEvent(this, qualifiedName, attributeValue) : new HtmlAttributeChangeEvent(this, qualifiedName, oldAttributeValue);
        super.setAttributeNS(namespaceURI, qualifiedName, attributeValue, notifyAttributeChangeListeners, notifyMutationObservers);
        if (notifyAttributeChangeListeners) {
            HtmlElement.notifyAttributeChangeListeners(event, this, oldAttributeValue, notifyMutationObservers);
        }
        this.fireAttributeChangeImpl(event, htmlPage, mappedElement, qualifiedName, attributeValue, oldAttributeValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void notifyAttributeChangeListeners(HtmlAttributeChangeEvent event, HtmlElement element, String oldAttributeValue, boolean notifyMutationObservers) {
        Collection<HtmlAttributeChangeListener> collection;
        Collection<HtmlAttributeChangeListener> listeners = element.attributeListeners_;
        if (oldAttributeValue == ATTRIBUTE_NOT_DEFINED) {
            collection = listeners;
            synchronized (collection) {
                for (HtmlAttributeChangeListener listener : listeners) {
                    if (!notifyMutationObservers && listener instanceof MutationObserver) continue;
                    listener.attributeAdded(event);
                }
            }
        }
        collection = listeners;
        synchronized (collection) {
            for (HtmlAttributeChangeListener listener : listeners) {
                if (!notifyMutationObservers && listener instanceof MutationObserver) continue;
                listener.attributeReplaced(event);
            }
        }
        DomNode parentNode = element.getParentNode();
        if (parentNode instanceof HtmlElement) {
            HtmlElement.notifyAttributeChangeListeners(event, (HtmlElement)parentNode, oldAttributeValue, notifyMutationObservers);
        }
    }

    private void fireAttributeChangeImpl(HtmlAttributeChangeEvent event, HtmlPage htmlPage, boolean mappedElement, String qualifiedName, String attributeValue, String oldAttributeValue) {
        if (mappedElement) {
            htmlPage.addMappedElement(this);
        }
        if (oldAttributeValue == ATTRIBUTE_NOT_DEFINED) {
            this.fireHtmlAttributeAdded(event);
            htmlPage.fireHtmlAttributeAdded(event);
        } else {
            this.fireHtmlAttributeReplaced(event);
            htmlPage.fireHtmlAttributeReplaced(event);
        }
    }

    @Override
    public Attr setAttributeNode(Attr attribute) {
        boolean mappedElement;
        String qualifiedName = attribute.getName();
        String oldAttributeValue = this.getAttribute(qualifiedName);
        HtmlPage htmlPage = (HtmlPage)this.getPage();
        boolean bl = mappedElement = this.isAttachedToPage() && HtmlPage.isMappedElement(htmlPage, qualifiedName);
        if (mappedElement) {
            htmlPage.removeMappedElement(this);
        }
        HtmlAttributeChangeEvent event = oldAttributeValue == ATTRIBUTE_NOT_DEFINED ? new HtmlAttributeChangeEvent(this, qualifiedName, attribute.getValue()) : new HtmlAttributeChangeEvent(this, qualifiedName, oldAttributeValue);
        HtmlElement.notifyAttributeChangeListeners(event, this, oldAttributeValue, true);
        Attr result = super.setAttributeNode(attribute);
        this.fireAttributeChangeImpl(event, htmlPage, mappedElement, qualifiedName, attribute.getValue(), oldAttributeValue);
        return result;
    }

    @Override
    public final void removeAttribute(String attributeName) {
        String value = this.getAttribute(attributeName);
        if (value == ATTRIBUTE_NOT_DEFINED) {
            return;
        }
        HtmlPage htmlPage = this.getHtmlPageOrNull();
        if (htmlPage != null) {
            htmlPage.removeMappedElement(this);
        }
        super.removeAttribute(attributeName);
        if (htmlPage != null) {
            htmlPage.addMappedElement(this);
            HtmlAttributeChangeEvent event = new HtmlAttributeChangeEvent(this, attributeName, value);
            this.fireHtmlAttributeRemoved(event);
            htmlPage.fireHtmlAttributeRemoved(event);
        }
    }

    protected void fireHtmlAttributeAdded(HtmlAttributeChangeEvent event) {
        DomNode parentNode = this.getParentNode();
        if (parentNode instanceof HtmlElement) {
            ((HtmlElement)parentNode).fireHtmlAttributeAdded(event);
        }
    }

    protected void fireHtmlAttributeReplaced(HtmlAttributeChangeEvent event) {
        DomNode parentNode = this.getParentNode();
        if (parentNode instanceof HtmlElement) {
            ((HtmlElement)parentNode).fireHtmlAttributeReplaced(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireHtmlAttributeRemoved(HtmlAttributeChangeEvent event) {
        Collection<HtmlAttributeChangeListener> collection = this.attributeListeners_;
        synchronized (collection) {
            for (HtmlAttributeChangeListener listener : this.attributeListeners_) {
                listener.attributeRemoved(event);
            }
        }
        DomNode parentNode = this.getParentNode();
        if (parentNode instanceof HtmlElement) {
            ((HtmlElement)parentNode).fireHtmlAttributeRemoved(event);
        }
    }

    @Override
    public String getNodeName() {
        String prefix = this.getPrefix();
        if (prefix != null) {
            StringBuilder name = new StringBuilder(prefix.toLowerCase(Locale.ROOT));
            name.append(':');
            name.append(this.getLocalName().toLowerCase(Locale.ROOT));
            return name.toString();
        }
        return this.getLocalName().toLowerCase(Locale.ROOT);
    }

    public Short getTabIndex() {
        String index = this.getAttributeDirect("tabindex");
        if (index == null || index.isEmpty()) {
            return null;
        }
        try {
            long l = Long.parseLong(index);
            if (l >= 0L && l <= 32767L) {
                return (short)l;
            }
            return TAB_INDEX_OUT_OF_BOUNDS;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public HtmlElement getEnclosingElement(String tagName) {
        String tagNameLC = tagName.toLowerCase(Locale.ROOT);
        for (DomNode currentNode = this.getParentNode(); currentNode != null; currentNode = currentNode.getParentNode()) {
            if (!(currentNode instanceof HtmlElement) || !currentNode.getNodeName().equals(tagNameLC)) continue;
            return (HtmlElement)currentNode;
        }
        return null;
    }

    public HtmlForm getEnclosingForm() {
        if (this.owningForm_ != null) {
            return this.owningForm_;
        }
        return (HtmlForm)this.getEnclosingElement("form");
    }

    public HtmlForm getEnclosingFormOrDie() {
        HtmlForm form = this.getEnclosingForm();
        if (form == null) {
            throw new IllegalStateException("Element is not contained within a form: " + this);
        }
        return form;
    }

    public void type(String text) throws IOException {
        for (char ch : text.toCharArray()) {
            this.type(ch);
        }
    }

    public Page type(char c) throws IOException {
        return this.type(c, false, true);
    }

    private Page type(char c, boolean startAtEnd, boolean lastType) throws IOException {
        HtmlForm form;
        ScriptResult shiftDownResult;
        KeyboardEvent shiftDown;
        boolean isShiftNeeded;
        if (this instanceof DisabledElement && ((DisabledElement)((Object)this)).isDisabled()) {
            return this.getPage();
        }
        this.getPage().getWebClient().setCurrentWindow(this.getPage().getEnclosingWindow());
        HtmlPage page = (HtmlPage)this.getPage();
        if (page.getFocusedElement() != this) {
            this.focus();
        }
        if (isShiftNeeded = KeyboardEvent.isShiftNeeded(c, this.shiftPressed_)) {
            shiftDown = new KeyboardEvent((DomNode)this, "keydown", 16, true, this.ctrlPressed_, this.altPressed_);
            shiftDownResult = this.fireEvent(shiftDown);
        } else {
            shiftDown = null;
            shiftDownResult = null;
        }
        KeyboardEvent keyDown = new KeyboardEvent((DomNode)this, "keydown", c, this.shiftPressed_ | isShiftNeeded, this.ctrlPressed_, this.altPressed_);
        ScriptResult keyDownResult = this.fireEvent(keyDown);
        if (!keyDown.isAborted(keyDownResult)) {
            KeyboardEvent keyPress = new KeyboardEvent((DomNode)this, "keypress", c, this.shiftPressed_ | isShiftNeeded, this.ctrlPressed_, this.altPressed_);
            ScriptResult keyPressResult = this.fireEvent(keyPress);
            if (!(shiftDown != null && shiftDown.isAborted(shiftDownResult) || keyPress.isAborted(keyPressResult))) {
                this.doType(c, startAtEnd, lastType);
            }
        }
        WebClient webClient = page.getWebClient();
        if (this instanceof HtmlTextInput || this instanceof HtmlTextArea || this instanceof HtmlPasswordInput) {
            this.fireKeyboardEvent("input", c, this.shiftPressed_ | isShiftNeeded);
        }
        this.fireKeyboardEvent("keyup", c, this.shiftPressed_ | isShiftNeeded);
        if (isShiftNeeded) {
            KeyboardEvent shiftUp = new KeyboardEvent((DomNode)this, "keyup", 16, false, this.ctrlPressed_, this.altPressed_);
            this.fireEvent(shiftUp);
        }
        if ((form = this.getEnclosingForm()) != null && c == '\n' && this.isSubmittableByEnter()) {
            HtmlSubmitInput submit = (HtmlSubmitInput)form.getFirstByXPath(".//input[@type='submit']");
            if (submit != null) {
                return submit.click();
            }
            form.submit((SubmittableElement)((Object)this));
            webClient.getJavaScriptEngine().processPostponedActions();
        }
        return webClient.getCurrentWindow().getEnclosedPage();
    }

    private void fireKeyboardEvent(String eventType, char c, boolean shift) {
        this.fireEvent(new KeyboardEvent((DomNode)this, eventType, c, shift, this.ctrlPressed_, this.altPressed_));
    }

    public Page type(int keyCode) {
        return this.type(keyCode, false, true, true, true, true);
    }

    public Page type(Keyboard keyboard) throws IOException {
        Page page = null;
        List<Object[]> keys = keyboard.getKeys();
        for (int i = 0; i < keys.size(); ++i) {
            boolean startAtEnd;
            Object[] entry = keys.get(i);
            boolean bl = startAtEnd = i == 0 && keyboard.isStartAtEnd();
            if (entry.length == 1) {
                this.type(((Character)entry[0]).charValue(), startAtEnd, i == keys.size() - 1);
                continue;
            }
            int key = (Integer)entry[0];
            boolean pressed = (Boolean)entry[1];
            switch (key) {
                case 16: {
                    this.shiftPressed_ = pressed;
                    break;
                }
                case 17: {
                    this.ctrlPressed_ = pressed;
                    break;
                }
                case 18: {
                    this.altPressed_ = pressed;
                    break;
                }
            }
            if (pressed) {
                boolean keyPress = true;
                boolean keyUp = true;
                switch (key) {
                    case 16: 
                    case 17: 
                    case 18: {
                        keyPress = false;
                        keyUp = false;
                        break;
                    }
                }
                page = this.type(key, startAtEnd, true, keyPress, keyUp, i == keys.size() - 1);
                continue;
            }
            page = this.type(key, startAtEnd, false, false, true, i == keys.size() - 1);
        }
        return page;
    }

    private Page type(int keyCode, boolean startAtEnd, boolean fireKeyDown, boolean fireKeyPress, boolean fireKeyUp, boolean lastType) {
        ScriptResult keyPressResult;
        Event keyPress;
        ScriptResult keyDownResult;
        KeyboardEvent keyDown;
        if (this instanceof DisabledElement && ((DisabledElement)((Object)this)).isDisabled()) {
            return this.getPage();
        }
        HtmlPage page = (HtmlPage)this.getPage();
        if (page.getFocusedElement() != this) {
            this.focus();
        }
        if (fireKeyDown) {
            keyDown = new KeyboardEvent((DomNode)this, "keydown", keyCode, this.shiftPressed_, this.ctrlPressed_, this.altPressed_);
            keyDownResult = this.fireEvent(keyDown);
        } else {
            keyDown = null;
            keyDownResult = null;
        }
        BrowserVersion browserVersion = page.getWebClient().getBrowserVersion();
        if (fireKeyPress && browserVersion.hasFeature(BrowserVersionFeatures.KEYBOARD_EVENT_SPECIAL_KEYPRESS)) {
            keyPress = new KeyboardEvent((DomNode)this, "keypress", keyCode, this.shiftPressed_, this.ctrlPressed_, this.altPressed_);
            keyPressResult = this.fireEvent(keyPress);
        } else {
            keyPress = null;
            keyPressResult = null;
        }
        if (!(keyDown == null || keyDown.isAborted(keyDownResult) || keyPress != null && keyPress.isAborted(keyPressResult))) {
            this.doType(keyCode, startAtEnd, lastType);
        }
        if (this instanceof HtmlTextInput || this instanceof HtmlTextArea || this instanceof HtmlPasswordInput) {
            KeyboardEvent input = new KeyboardEvent((DomNode)this, "input", keyCode, this.shiftPressed_, this.ctrlPressed_, this.altPressed_);
            this.fireEvent(input);
        }
        if (fireKeyUp) {
            KeyboardEvent keyUp = new KeyboardEvent((DomNode)this, "keyup", keyCode, this.shiftPressed_, this.ctrlPressed_, this.altPressed_);
            this.fireEvent(keyUp);
        }
        return page.getWebClient().getCurrentWindow().getEnclosedPage();
    }

    protected void doType(char c, boolean startAtEnd, boolean lastType) {
        DomNode domNode = this.getDoTypeNode();
        if (domNode instanceof DomText) {
            ((DomText)domNode).doType(c, startAtEnd, this, lastType);
        } else if (domNode instanceof HtmlElement) {
            try {
                ((HtmlElement)domNode).type(c, startAtEnd, lastType);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void doType(int keyCode, boolean startAtEnd, boolean lastType) {
        DomNode domNode = this.getDoTypeNode();
        if (domNode instanceof DomText) {
            ((DomText)domNode).doType(keyCode, startAtEnd, this, lastType);
        } else if (domNode instanceof HtmlElement) {
            ((HtmlElement)domNode).type(keyCode, startAtEnd, true, true, true, lastType);
        }
    }

    private DomNode getDoTypeNode() {
        DomNode node = null;
        HTMLElement scriptElement = (HTMLElement)this.getScriptableObject();
        if (scriptElement.isIsContentEditable() || "on".equals(((Document)scriptElement.getOwnerDocument()).getDesignMode())) {
            NodeList children = this.getChildNodes();
            if (!children.isEmpty()) {
                DomNode lastChild = (DomNode)children.get(children.size() - 1);
                if (lastChild instanceof DomText) {
                    node = lastChild;
                } else if (lastChild instanceof HtmlElement) {
                    node = lastChild;
                }
            }
            if (node == null) {
                DomText domText = new DomText(this.getPage(), "");
                this.appendChild(domText);
                node = domText;
            }
        }
        return node;
    }

    protected void typeDone(String newValue, boolean notifyAttributeChangeListeners) {
    }

    protected boolean acceptChar(char c) {
        return !(c >= '\ue000' && c <= '\uf8ff' || c != ' ' && Character.isWhitespace(c));
    }

    protected boolean isSubmittableByEnter() {
        return false;
    }

    public final <E extends HtmlElement> E getOneHtmlElementByAttribute(String elementName, String attributeName, String attributeValue) throws ElementNotFoundException {
        WebAssert.notNull("elementName", elementName);
        WebAssert.notNull("attributeName", attributeName);
        WebAssert.notNull("attributeValue", attributeValue);
        List<E> list = this.getElementsByAttribute(elementName, attributeName, attributeValue);
        if (list.isEmpty()) {
            throw new ElementNotFoundException(elementName, attributeName, attributeValue);
        }
        return (E)((HtmlElement)list.get(0));
    }

    public final <E extends HtmlElement> List<E> getElementsByAttribute(String elementName, String attributeName, String attributeValue) {
        ArrayList<HtmlElement> list = new ArrayList<HtmlElement>();
        String lowerCaseTagName = elementName.toLowerCase(Locale.ROOT);
        for (HtmlElement next : this.getHtmlElementDescendants()) {
            String attValue;
            if (!next.getTagName().equals(lowerCaseTagName) || (attValue = next.getAttribute(attributeName)) == null || !attValue.equals(attributeValue)) continue;
            list.add(next);
        }
        return list;
    }

    public final HtmlElement appendChildIfNoneExists(String tagName) {
        HtmlElement child;
        NodeList children = this.getElementsByTagName(tagName);
        if (children.isEmpty()) {
            child = (HtmlElement)((HtmlPage)this.getPage()).createElement(tagName);
            this.appendChild(child);
        } else {
            child = (HtmlElement)children.get(0);
        }
        return child;
    }

    public final void removeChild(String tagName, int i) {
        NodeList children = this.getElementsByTagName(tagName);
        if (i >= 0 && i < children.size()) {
            ((HtmlElement)children.get(i)).remove();
        }
    }

    public final boolean hasEventHandlers(String eventName) {
        Object jsObj = this.getScriptableObject();
        if (jsObj instanceof EventTarget) {
            return ((EventTarget)jsObj).hasEventHandlers(eventName);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHtmlAttributeChangeListener(HtmlAttributeChangeListener listener) {
        WebAssert.notNull("listener", listener);
        Collection<HtmlAttributeChangeListener> collection = this.attributeListeners_;
        synchronized (collection) {
            this.attributeListeners_.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHtmlAttributeChangeListener(HtmlAttributeChangeListener listener) {
        WebAssert.notNull("listener", listener);
        Collection<HtmlAttributeChangeListener> collection = this.attributeListeners_;
        synchronized (collection) {
            this.attributeListeners_.remove(listener);
        }
    }

    @Override
    protected void checkChildHierarchy(Node childNode) throws DOMException {
        if (!(childNode instanceof Element || childNode instanceof Text || childNode instanceof Comment || childNode instanceof ProcessingInstruction || childNode instanceof CDATASection || childNode instanceof EntityReference)) {
            throw new DOMException(3, "The Element may not have a child of this type: " + childNode.getNodeType());
        }
        super.checkChildHierarchy(childNode);
    }

    void setOwningForm(HtmlForm form) {
        this.owningForm_ = form;
    }

    @Override
    protected boolean isAttributeCaseSensitive() {
        return false;
    }

    public final String getLangAttribute() {
        return this.getAttributeDirect("lang");
    }

    public final String getXmlLangAttribute() {
        return this.getAttribute("xml:lang");
    }

    public final String getTextDirectionAttribute() {
        return this.getAttributeDirect("dir");
    }

    public final String getOnClickAttribute() {
        return this.getAttributeDirect("onclick");
    }

    public final String getOnDblClickAttribute() {
        return this.getAttributeDirect("ondblclick");
    }

    public final String getOnMouseDownAttribute() {
        return this.getAttributeDirect("onmousedown");
    }

    public final String getOnMouseUpAttribute() {
        return this.getAttributeDirect("onmouseup");
    }

    public final String getOnMouseOverAttribute() {
        return this.getAttributeDirect("onmouseover");
    }

    public final String getOnMouseMoveAttribute() {
        return this.getAttributeDirect("onmousemove");
    }

    public final String getOnMouseOutAttribute() {
        return this.getAttributeDirect("onmouseout");
    }

    public final String getOnKeyPressAttribute() {
        return this.getAttributeDirect("onkeypress");
    }

    public final String getOnKeyDownAttribute() {
        return this.getAttributeDirect("onkeydown");
    }

    public final String getOnKeyUpAttribute() {
        return this.getAttributeDirect("onkeyup");
    }

    @Override
    public String getCanonicalXPath() {
        DomNode parent = this.getParentNode();
        if (parent.getNodeType() == 9) {
            return "/" + this.getNodeName();
        }
        return parent.getCanonicalXPath() + '/' + this.getXPathToken();
    }

    private String getXPathToken() {
        DomNode parent = this.getParentNode();
        int total = 0;
        int nodeIndex = 0;
        for (DomNode child : parent.getChildren()) {
            if (child.getNodeType() == 1 && child.getNodeName().equals(this.getNodeName())) {
                ++total;
            }
            if (child != this) continue;
            nodeIndex = total;
        }
        if (nodeIndex == 1 && total == 1) {
            return this.getNodeName();
        }
        return this.getNodeName() + '[' + nodeIndex + ']';
    }

    @Override
    public boolean isDisplayed() {
        if (ATTRIBUTE_NOT_DEFINED != this.getAttributeDirect("hidden")) {
            return false;
        }
        return super.isDisplayed();
    }

    public DisplayStyle getDefaultStyleDisplay() {
        return DisplayStyle.BLOCK;
    }

    protected final String getSrcAttributeNormalized() {
        String attrib = this.getAttributeDirect("src");
        if (ATTRIBUTE_NOT_DEFINED == attrib) {
            return attrib;
        }
        return StringUtils.replaceChars(attrib, "\r\n", "");
    }

    @Override
    protected void detach() {
        Object document = this.getPage().getScriptableObject();
        if (document instanceof HTMLDocument) {
            HTMLDocument doc = (HTMLDocument)document;
            HTMLElement activeElement = doc.getActiveElement();
            if (activeElement == this.getScriptableObject()) {
                doc.setActiveElement(null);
                if (this.hasFeature(BrowserVersionFeatures.HTMLELEMENT_REMOVE_ACTIVE_TRIGGERS_BLUR_EVENT)) {
                    ((HtmlPage)this.getPage()).setFocusedElement(null);
                } else {
                    ((HtmlPage)this.getPage()).setElementWithFocus(null);
                }
            } else {
                Iterator iterator = this.getChildNodes().iterator();
                while (iterator.hasNext()) {
                    DomNode child = (DomNode)iterator.next();
                    if (activeElement != child.getScriptableObject()) continue;
                    doc.setActiveElement(null);
                    if (this.hasFeature(BrowserVersionFeatures.HTMLELEMENT_REMOVE_ACTIVE_TRIGGERS_BLUR_EVENT)) {
                        ((HtmlPage)this.getPage()).setFocusedElement(null);
                        break;
                    }
                    ((HtmlPage)this.getPage()).setElementWithFocus(null);
                    break;
                }
            }
        }
        super.detach();
    }

    @Override
    public boolean handles(Event event) {
        if ("blur".equals(event.getType()) || "focus".equals(event.getType())) {
            return this instanceof SubmittableElement || this.getTabIndex() != null;
        }
        if (this instanceof DisabledElement && ((DisabledElement)((Object)this)).isDisabled()) {
            return false;
        }
        return super.handles(event);
    }

    protected boolean isShiftPressed() {
        return this.shiftPressed_;
    }

    public boolean isCtrlPressed() {
        return this.ctrlPressed_;
    }

    public boolean isAltPressed() {
        return this.altPressed_;
    }

    public boolean isValid() {
        return !this.isRequiredSupported() || this.getAttributeDirect("required") == ATTRIBUTE_NOT_DEFINED || !this.getAttributeDirect("value").isEmpty();
    }

    protected boolean isRequiredSupported() {
        return false;
    }

    public boolean isRequired() {
        return this.isRequiredSupported() && this.hasAttribute("required");
    }

    public void setRequired(boolean required) {
        if (this.isRequiredSupported()) {
            if (required) {
                this.setAttribute("required", "required");
            } else {
                this.removeAttribute("required");
            }
        }
    }

    @Override
    public DomNode cloneNode(boolean deep) {
        HtmlElement newnode = (HtmlElement)super.cloneNode(deep);
        newnode.attributeListeners_ = new LinkedHashSet<HtmlAttributeChangeListener>(this.attributeListeners_);
        return newnode;
    }

    public static enum DisplayStyle {
        EMPTY(""),
        NONE("none"),
        BLOCK("block"),
        INLINE("inline"),
        INLINE_BLOCK("inline-block"),
        LIST_ITEM("list-item"),
        TABLE("table"),
        TABLE_CELL("table-cell"),
        TABLE_COLUMN("table-column"),
        TABLE_COLUMN_GROUP("table-column-group"),
        TABLE_ROW("table-row"),
        TABLE_ROW_GROUP("table-row-group"),
        TABLE_HEADER_GROUP("table-header-group"),
        TABLE_FOOTER_GROUP("table-footer-group"),
        TABLE_CAPTION("table-caption"),
        RUBY("ruby"),
        RUBY_TEXT("ruby-text");

        private final String value_;

        private DisplayStyle(String value) {
            this.value_ = value;
        }

        public String value() {
            return this.value_;
        }
    }
}

