/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.CharacterDataChangeEvent;
import com.gargoylesoftware.htmlunit.html.DomNode;
import org.w3c.dom.CharacterData;

public abstract class DomCharacterData
extends DomNode
implements CharacterData {
    private String data_;

    public DomCharacterData(SgmlPage page, String data) {
        super(page);
        this.setData(data);
    }

    @Override
    public String getData() {
        return this.data_;
    }

    @Override
    public void setData(String data) {
        String oldData = this.data_;
        this.data_ = data;
        this.fireCharacterDataChanged(new CharacterDataChangeEvent(this, oldData));
    }

    @Override
    public void setNodeValue(String newValue) {
        this.setData(newValue);
    }

    @Override
    public void setTextContent(String textContent) {
        this.setData(textContent);
    }

    @Override
    public int getLength() {
        return this.data_.length();
    }

    @Override
    public void appendData(String newData) {
        this.data_ = this.data_ + newData;
    }

    @Override
    public void deleteData(int offset, int count) {
        int fromLeft;
        if (offset < 0) {
            throw new IllegalArgumentException("Provided offset: " + offset + " is less than zero.");
        }
        String data = this.data_.substring(0, offset);
        if (count >= 0 && (fromLeft = offset + count) < this.data_.length()) {
            this.setData(data + this.data_.substring(fromLeft, this.data_.length()));
            return;
        }
        this.setData(data);
    }

    @Override
    public void insertData(int offset, String arg) {
        this.setData(new StringBuilder(this.data_).insert(offset, arg).toString());
    }

    @Override
    public void replaceData(int offset, int count, String arg) {
        this.deleteData(offset, count);
        this.insertData(offset, arg);
    }

    @Override
    public String substringData(int offset, int count) {
        int length = this.data_.length();
        if (count < 0 || offset < 0 || offset > length - 1) {
            throw new IllegalArgumentException("offset: " + offset + " count: " + count);
        }
        int tailIndex = Math.min(offset + count, length);
        return this.data_.substring(offset, tailIndex);
    }

    @Override
    public String getNodeValue() {
        return this.data_;
    }

    @Override
    public String getCanonicalXPath() {
        return this.getParentNode().getCanonicalXPath() + '/' + this.getXPathToken();
    }

    private String getXPathToken() {
        DomNode parent = this.getParentNode();
        int siblingsOfSameType = 0;
        int nodeIndex = 0;
        for (DomNode child : parent.getChildren()) {
            if (child == this) {
                if ((nodeIndex = ++siblingsOfSameType) <= 1) continue;
                break;
            }
            if (child.getNodeType() != this.getNodeType()) continue;
            ++siblingsOfSameType;
            if (nodeIndex <= 0) continue;
            break;
        }
        String nodeName = this.getNodeName().substring(1) + "()";
        if (siblingsOfSameType == 1) {
            return nodeName;
        }
        return nodeName + '[' + nodeIndex + ']';
    }
}

